

#include <windows.h>
#include <stdio.h>
#include <gl\GL.h>
#include <gl\GLU.h>
#include <fstream>
#include <string.h>
#include <map>


// assimp include files. These three are usually needed.
#include "assimp.hpp"	//OO version Header!
#include "aiPostProcess.h"
#include "aiScene.h"

// the global Assimp scene object
const struct aiScene* scene = NULL;



const struct aiScene* scene_list[2000];
char scene_list_types[2000][80];
GLuint numLoadedScenes = 0;

 


struct aiVector3D scene_min, scene_max, scene_center;

// current rotation angle
static float angle = 0.f;

#define aisgl_min(x,y) (x<y?x:y)
#define aisgl_max(x,y) (y>x?y:x)

//char PT[256]="C:\\WinrottGL__168\\assimp\\assimp--2.0.863-sdk\\test\\models\\X\\Testwuson.X";
// currently these are hardcoded
std::string basepath = "";//C:/WinrottGL__168/assimp/assimp--2.0.863-sdk/test/models/x/";
std::string modelname = "";//fromtruespace_bin32.x";//bigbtorch.MD2 jeep1.ms3d

GLfloat		xrot;
GLfloat		yrot;
GLfloat		zrot;

GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };
GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };
GLfloat LightPosition[]= { 0.0f, 0.0f, 15.0f, 1.0f };

// the global Assimp scene object
//const aiScene* scene = NULL;
//GLuint scene_list = 0;
//struct aiVector3D scene_min, scene_max, scene_center;

// images / texture
std::map<std::string, GLuint*> textureIdMap;	// map image filenames to textureIds
GLuint*		textureIds;							// pointer to texture Array

// Create an instance of the Importer class
Assimp::Importer importer;

extern "C" {
	extern int LoadExtImgToTexture (const char *path_buffer, int repeat, int mipmaps, int *w, int *h);
	extern int LoadModelTexture (const char *fname, int repeat, int mipmaps, int *w, int *h);
	extern float testf;
	extern int  pl_x,pl_y,pl_z,pl_ang;
	extern long plx,ply,plz,plang;
	extern void ErrorDontQuit (char *error, int i,...);
	extern int atan2_appx (int dx, int dy);
	extern int FindDistance (int ix, int iy);
}


bool Import3DFromFile(char *Modelname, char *Modelpath);
int DrawGLScene(char *modelname,float x,float y,float z,float xoff,float yoff,float zoff);
int LoadGLTextures(const aiScene* scene);




// ----------------------------------------------------------------------------

bool Import3DFromFile(char *Modelname, char *Modelpath)
{
	char fullfn[256];

	lstrcpy(fullfn, Modelpath);	
	basepath.clear ();
	basepath.append(fullfn);
	basepath.append("/");

	lstrcpy(fullfn, Modelname);	
	modelname.clear ();
	modelname.append(fullfn);

	lstrcpy(fullfn, Modelpath);	
	lstrcat(fullfn, "/");
	lstrcat(fullfn, Modelname);	
	for (int yu=0; yu < lstrlen(fullfn);yu++){
		if (*(fullfn+yu) == '\\')
			*(fullfn+yu) = '/';
	}
	std::string pFile;// = basepath + modelname;	// Loading of image 
	//lstrcpy((char*)pFile.c_str(), fullfn);
	pFile.append (fullfn);

	//check if file exists
	std::ifstream fin(pFile.c_str());
	if(!fin.fail())
	{
		fin.close();
	}
	else
	{
		MessageBox(NULL, ("Couldn't open file: " + pFile).c_str() , "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return false;
	}

	//	textureIds = new GLuint[numTextures];
//	scene_list = new struct aiScene[numLoadedScenes];


	scene_list[numLoadedScenes] = importer.ReadFile( pFile, aiProcessPreset_TargetRealtime_Quality);

	// If the import failed, report it scene_list[numLoadedScenes]
	if( !scene_list[numLoadedScenes])
	{
		return false;
	}

	LoadGLTextures(scene_list[numLoadedScenes]);


	lstrcpy(scene_list_types[numLoadedScenes],Modelname);
int qw = sizeof(aiScene);
	numLoadedScenes++;

//	memcpy (scene_list[0],&scene,sizeof(scene));
	return true;
}



int LoadGLTextures(const aiScene* scene)
{
	if (scene->HasTextures()) {
		ErrorDontQuit("Support for meshes with embedded textures is not implemented",0);
		return -1;
	}
	/* getTexture Filenames and Numb of Textures */
	for (unsigned int m=0; m<scene->mNumMaterials; m++)
	{
		int texIndex = 0;
		aiReturn texFound = AI_SUCCESS;

		aiString path;	// filename
		while (texFound == AI_SUCCESS)
		{
			texFound = scene->mMaterials[m]->GetTexture(aiTextureType_DIFFUSE, texIndex, &path);
			textureIdMap[path.data] = NULL; //fill map with textures, pointers still NULL yet
			texIndex++;
		}
	}

	int numTextures = textureIdMap.size();
	/* create and fill array with GL texture ids */
	textureIds = new GLuint[numTextures];
	glGenTextures(numTextures, textureIds); /* Texture name generation */

	/* get iterator */
	std::map<std::string, GLuint*>::iterator itr = textureIdMap.begin();

	for (int i=0; i<numTextures; i++)
	{
		char fn[256];

		//save IL image ID
		std::string filename;

		filename.clear ();
		filename = (*itr).first;  // get filename
		(*itr).second =  &textureIds[i];	  // save texture id for filename in map
		itr++;								  // next texture

		//check for bad paths like /setting/tmp/image1.bmp
		lstrcpy((char*)fn,(LPCSTR)filename.c_str());

		for (int yu=0; yu < lstrlen(fn);yu++){
			if (*(fn+yu) == '\\')
				*(fn+yu) = '/';
		}
		char *ptr = strrchr (fn,'/');
		if (ptr == 0)
			ptr = strrchr (fn,'\\');


		if (ptr != 0){
			filename.clear ();
			filename.append (ptr+1);
		}else{
			filename.clear ();
			filename.append (fn);
		}

		std::string fileloc = basepath + filename;	/* Loading of image */

		lstrcpy((char*)fn,(LPCSTR)fileloc.c_str());

		int w,h;
		//try model name, LoadExtImgToTexture will try 4 different gfx types
		if (filename.empty() == true){
			lstrcpy((char*)fn,(LPCSTR)basepath.c_str());
			lstrcat((char*)fn,(LPCSTR)modelname.c_str());
		}
        textureIds[i] = LoadExtImgToTexture(fn,1,20,&w,&h); 	
	}

	return TRUE;
}


// Can't send color down as a pointer to aiColor4D because AI colors are ABGR.
void Color4f(const struct aiColor4D *color)
{
	glColor4f(color->r, color->g, color->b, color->a);
}

void set_float4(float f[4], float a, float b, float c, float d)
{
	f[0] = a;f[1] = b;f[2] = c;f[3] = d;
}

void color4_to_float4(const struct aiColor4D *c, float f[4])
{
	f[0] = c->r;f[1] = c->g;f[2] = c->b;f[3] = c->a;
}

void apply_material(const struct aiMaterial *mtl)
{
	float c[4];

	GLenum fill_mode;
	int ret1, ret2;
	struct aiColor4D diffuse;
	struct aiColor4D specular;
	struct aiColor4D ambient;
	struct aiColor4D emission;
	float shininess, strength;
	int two_sided;
	int wireframe;
	unsigned int max;	// changed: to unsigned

	int texIndex = 0;
	aiString texPath;	//contains filename of texture

	if(AI_SUCCESS == mtl->GetTexture(aiTextureType_DIFFUSE, texIndex, &texPath))
	{
		//bind texture
		unsigned int texId = *textureIdMap[texPath.data];
		glBindTexture(GL_TEXTURE_2D, texId);
	}

	set_float4(c, 0.8f, 0.8f, 0.8f, 1.0f);
	if(AI_SUCCESS == aiGetMaterialColor(mtl, AI_MATKEY_COLOR_DIFFUSE, &diffuse))
		color4_to_float4(&diffuse, c);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, c);

	set_float4(c, 0.0f, 0.0f, 0.0f, 1.0f);
	if(AI_SUCCESS == aiGetMaterialColor(mtl, AI_MATKEY_COLOR_SPECULAR, &specular))
		color4_to_float4(&specular, c);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, c);

	set_float4(c, 0.2f, 0.2f, 0.2f, 1.0f);
	if(AI_SUCCESS == aiGetMaterialColor(mtl, AI_MATKEY_COLOR_AMBIENT, &ambient))
		color4_to_float4(&ambient, c);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, c);

	set_float4(c, 0.0f, 0.0f, 0.0f, 1.0f);
	if(AI_SUCCESS == aiGetMaterialColor(mtl, AI_MATKEY_COLOR_EMISSIVE, &emission))
		color4_to_float4(&emission, c);
	glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, c);

	max = 1;
	ret1 = aiGetMaterialFloatArray(mtl, AI_MATKEY_SHININESS, &shininess, &max);
	max = 1;
	ret2 = aiGetMaterialFloatArray(mtl, AI_MATKEY_SHININESS_STRENGTH, &strength, &max);
	if((ret1 == AI_SUCCESS) && (ret2 == AI_SUCCESS))
		glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess * strength);
	else {
		glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 0.0f);
		set_float4(c, 0.0f, 0.0f, 0.0f, 0.0f);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, c);
	}

	max = 1;
	if(AI_SUCCESS == aiGetMaterialIntegerArray(mtl, AI_MATKEY_ENABLE_WIREFRAME, &wireframe, &max))
		fill_mode = wireframe ? GL_LINE : GL_FILL;
	else
		fill_mode = GL_FILL;
	glPolygonMode(GL_FRONT_AND_BACK, fill_mode);

	max = 1;
	if((AI_SUCCESS == aiGetMaterialIntegerArray(mtl, AI_MATKEY_TWOSIDED, &two_sided, &max)) && two_sided)
		glEnable(GL_CULL_FACE);
	else
		glDisable(GL_CULL_FACE);
}



void recursive_render (const struct aiScene *sc, const struct aiNode* nd, float scale)
{
	unsigned int i;
	unsigned int n=0, t;
	struct aiMatrix4x4 m = nd->mTransformation;

	m.Scaling(aiVector3D(scale, scale, scale), m);

	// update transform
	m.Transpose();
	glMultMatrixf((float*)&m);

	// draw all meshes assigned to this node
	for (; n < nd->mNumMeshes; ++n)
	{
		const struct aiMesh* mesh = sc->mMeshes[nd->mMeshes[n]];

		apply_material(sc->mMaterials[mesh->mMaterialIndex]);


		if(mesh->mNormals == NULL)
		{
			//glDisable(GL_LIGHTING);
		}
		else
		{
			//glEnable(GL_LIGHTING);
		}

		if(mesh->mColors[0] != NULL)
		{
			glEnable(GL_COLOR_MATERIAL);
		}
		else
		{
			glDisable(GL_COLOR_MATERIAL);
		}

		for (t = 0; t < mesh->mNumFaces; ++t) {
			const struct aiFace* face = &mesh->mFaces[t];
			GLenum face_mode;

			switch(face->mNumIndices)
			{
				case 1: face_mode = GL_POINTS; break;
				case 2: face_mode = GL_LINES; break;
				case 3: face_mode = GL_TRIANGLES; break;
				default: face_mode = GL_POLYGON; break;
			}

			glBegin(face_mode);

			for(i = 0; i < face->mNumIndices; i++)		// go through all vertices in face
			{
				int vertexIndex = face->mIndices[i];	// get group index for current index
				if(mesh->mColors[0] != NULL)
					Color4f(&mesh->mColors[0][vertexIndex]);
				if(mesh->mNormals != NULL)

					if(mesh->HasTextureCoords(0))		//HasTextureCoords(texture_coordinates_set)
					{
						glTexCoord2f(mesh->mTextureCoords[0][vertexIndex].x, 1 - mesh->mTextureCoords[0][vertexIndex].y); //mTextureCoords[channel][vertex]
					}

					glNormal3fv(&mesh->mNormals[vertexIndex].x);
					glVertex3fv(&mesh->mVertices[vertexIndex].x);
			}
			glEnd();
		}

	}

	for (n = 0; n < nd->mNumChildren; ++n)
	{
		recursive_render(sc, nd->mChildren[n], scale);
	}
}



void drawAiScene(const aiScene* scene)
{
	recursive_render(scene, scene->mRootNode, 1.0);
}



//Here's where we do all the drawing
int DrawGLScene(char *modelname, float x,float y,float z,float xoff,float yoff,float zoff)				
{

	for(int ew=0;ew < numLoadedScenes;ew++){
		if (lstrcmpi(modelname,scene_list_types[ew])==0){
			if (ew>0){
				break;
			}
//			if (scene_list[ew] != 0)
		{
		drawAiScene(scene_list[ew]);
		return 1;

	}
	return 0;				
}
	}
}


